section {* More on Terms *}

(* author: Andrei Popescu *)

theory Terms imports Transition_QuasiTerms_Terms
begin

text{* In this section, we continue the study of terms, with stating and proving
properties specific to terms (while in the previous section we dealt with
lifting properties from quasi-terms).
Consequently, in this theory, not only the theorems, but neither the proofs
should mention quasi-items at all.
Among the properties specific to terms will
be the compositionality properties of substitution (while, by contrast, similar properties
of swapping also held for quasi-tems).
 *}

context FixVars (* scope all throughout the file *)
begin

declare qItem_simps[simp del]
declare qItem_versus_item_simps[simp del]

subsection {* Identity environment versus other operators *}

(* Recall theorem getEnv_idEnv. *)

theorem getEnv_updEnv_idEnv[simp]:
"(idEnv [x \<leftarrow> X]_xs) ys y = (if (ys = xs \<and> y = x) then Some X else None)"
unfolding idEnv_def updEnv_def by simp

theorem subst_psubst_idEnv:
"(X #[Y / y]_ys) = (X #[idEnv [y \<leftarrow> Y]_ys])"
unfolding subst_def idEnv_def updEnv_def psubst_def by simp

theorem vsubst_psubst_idEnv:
"(X #[z // y]_ys) = (X #[idEnv [y \<leftarrow> Var ys z]_ys])"
unfolding vsubst_def by(simp add: subst_psubst_idEnv)

theorem substEnv_psubstEnv_idEnv:
"(rho &[Y / y]_ys) = (rho &[idEnv [y \<leftarrow> Y]_ys])"
unfolding substEnv_def idEnv_def updEnv_def psubstEnv_def by simp

theorem vsubstEnv_psubstEnv_idEnv:
"(rho &[z // y]_ys) = (rho &[idEnv [y \<leftarrow> Var ys z]_ys])"
unfolding vsubstEnv_def by (simp add: substEnv_psubstEnv_idEnv)

theorem freshEnv_idEnv: "freshEnv xs x idEnv"
unfolding idEnv_def freshEnv_def liftAll_def by simp

theorem swapEnv_idEnv[simp]: "(idEnv &[x \<and> y]_xs) = idEnv"
unfolding idEnv_def swapEnv_def comp_def swapEnvDom_def swapEnvIm_def lift_def by simp

theorem psubstEnv_idEnv[simp]: "(idEnv &[rho]) = rho"
unfolding idEnv_def psubstEnv_def lift_def by simp

theorem substEnv_idEnv: "(idEnv &[X / x]_xs) = (idEnv [x \<leftarrow> X]_xs)"
unfolding substEnv_def using psubstEnv_idEnv by auto

theorem vsubstEnv_idEnv: "(idEnv &[y // x]_xs) = (idEnv [x \<leftarrow> (Var xs y)]_xs)"
unfolding vsubstEnv_def using substEnv_idEnv .

lemma psubstAll_idEnv:
fixes X::"('index,'bindex,'varSort,'var,'opSym)term" and
      A::"('index,'bindex,'varSort,'var,'opSym)abs"
shows
"(good X  \<longrightarrow> (X #[idEnv]) = X) \<and>
 (goodAbs A  \<longrightarrow> (A $[idEnv]) = A)"
apply(rule term_rawInduct)
apply (simp_all del: getEnv_idEnv)  (* strange: why did I need to delete this? *)
unfolding psubstInp_def psubstBinp_def
apply (simp_all del: getEnv_idEnv add: liftAll_lift_ext lift_ident freshEnv_idEnv)
proof-
  fix xs :: 'varSort and x :: 'var
  have "idEnv xs x = None" by simp
  thus "((Var xs x) #[idEnv]) = Var xs x"
  by auto
qed

lemma psubst_idEnv[simp]:
"good X \<Longrightarrow> (X #[idEnv]) = X"
by(simp add: psubstAll_idEnv)

lemma psubstEnv_idEnv_id[simp]:
assumes "goodEnv rho"
shows "(rho &[idEnv]) = rho"
unfolding psubstEnv_def lift_def
apply(rule ext)+
using assms unfolding goodEnv_def liftAll_def
by(case_tac "rho xs x", auto)

subsection {* Environment update versus other operators *}

(* Recall theorem getEnv_updEnv. *)

theorem updEnv_overwrite[simp]: "((rho [x \<leftarrow> X]_xs) [x \<leftarrow> X']_xs) = (rho [x \<leftarrow> X']_xs)"
unfolding updEnv_def apply(rule ext)+ by auto

theorem updEnv_commute:
assumes "xs \<noteq> ys \<or> x \<noteq> y"
shows "((rho [x \<leftarrow> X]_xs) [y \<leftarrow> Y]_ys) = ((rho [y \<leftarrow> Y]_ys) [x \<leftarrow> X]_xs)"
apply(rule ext)+ using assms unfolding updEnv_def by auto

theorem freshEnv_updEnv_E1:
assumes "freshEnv xs y (rho [x \<leftarrow> X]_xs)"
shows "y \<noteq> x"
using assms unfolding freshEnv_def liftAll_def updEnv_def by auto

theorem freshEnv_updEnv_E2:
assumes "freshEnv ys y (rho [x \<leftarrow> X]_xs)"
shows "fresh ys y X"
using assms unfolding freshEnv_def liftAll_def updEnv_def apply auto
by(drule allE[of _ xs], drule allE[of _ x], auto)

theorem freshEnv_updEnv_E3:
assumes "freshEnv ys y (rho [x \<leftarrow> X]_xs)"
shows "rho ys y = None"
proof-
  let ?rho' = "rho [x \<leftarrow> X]_xs"
  have "?rho' ys y = None" using assms unfolding freshEnv_def by simp
  hence "ys = xs \<and> x = y \<or> rho ys y = None" by(cases "ys = xs \<and> x = y", auto)
  thus ?thesis using assms freshEnv_updEnv_E1[of ys y] by auto
qed

theorem freshEnv_updEnv_E4:
assumes *: "freshEnv ys y (rho [x \<leftarrow> X]_xs)"
and "zs \<noteq> xs \<or> z \<noteq> x" and "rho zs z = Some Z"
shows "fresh ys y Z"
proof-
  let ?rho' = "rho [x \<leftarrow> X]_xs"
  have "?rho' zs z = Some Z" using assms by auto
  thus ?thesis using * unfolding freshEnv_def liftAll_def by auto
qed

theorem freshEnv_updEnv_I:
assumes *: "ys \<noteq> xs \<or> y \<noteq> x" and **: "fresh ys y X" and ***: "rho ys y = None"
and ****: "\<And> zs z Z. \<lbrakk>zs \<noteq> xs \<or> z \<noteq> x; rho zs z = Some Z\<rbrakk> \<Longrightarrow> fresh ys y Z"
shows "freshEnv ys y (rho [x \<leftarrow> X]_xs)"
unfolding freshEnv_def liftAll_def
proof(tactic {* mauto_no_simp_tac @{context} *})
  show "(rho [x \<leftarrow> X]_xs) ys y = None" using * *** unfolding updEnv_def by auto
next
  fix zs z Z assume rho: "(rho [x \<leftarrow> X]_xs) zs z = Some Z"
  show "fresh ys y Z"
  proof(cases "zs = xs \<and> z = x")
    assume Case1: "zs = xs \<and> z = x"
    hence "Z = X" using rho by auto
    thus ?thesis using ** by simp
  next
   assume Case2: "\<not> (zs = xs \<and> z = x)"
   hence "rho zs z = Some Z" using rho by auto
   thus ?thesis using **** Case2 by simp
  qed
qed

theorem swapEnv_updEnv:
"((rho [x \<leftarrow> X]_xs) &[y1 \<and> y2]_ys) =
 ((rho &[y1 \<and> y2]_ys) [(x @xs[y1 \<and> y2]_ys) \<leftarrow> (X #[y1 \<and> y2]_ys)]_xs)"
unfolding swapEnv_defs sw_def lift_def
apply(rule ext)+ by(cases "xs = ys", auto)

lemma swapEnv_updEnv_fresh:
assumes "ys \<noteq> xs \<or> x \<notin> {y1,y2}" and "good X"
and "fresh ys y1 X" and "fresh ys y2 X"
shows "((rho [x \<leftarrow> X]_xs) &[y1 \<and> y2]_ys) =
       ((rho &[y1 \<and> y2]_ys) [x \<leftarrow> X]_xs)"
using assms by(simp add: swapEnv_updEnv)

theorem psubstEnv_updEnv:
"((rho [x \<leftarrow> X]_xs) &[rho']) = ((rho &[rho']) [x \<leftarrow> (X #[rho'])]_xs)"
unfolding psubstEnv_def
apply(rule ext)+ by auto

theorem psubstEnv_updEnv_idEnv:
"((idEnv [x \<leftarrow> X]_xs) &[rho]) = (rho [x \<leftarrow> (X #[rho])]_xs)"
by(simp add: psubstEnv_updEnv)

theorem substEnv_updEnv:
"((rho [x \<leftarrow> X]_xs) &[Y / y]_ys) = ((rho &[Y / y]_ys) [x \<leftarrow> (X #[Y / y]_ys)]_xs)"
unfolding substEnv_def subst_def by(rule psubstEnv_updEnv)

theorem vsubstEnv_updEnv:
"((rho [x \<leftarrow> X]_xs) &[y1 // y]_ys) = ((rho &[y1 // y]_ys) [x \<leftarrow> (X #[y1 // y]_ys)]_xs)"
unfolding vsubstEnv_def vsubst_def using substEnv_updEnv .

subsection {* Environment ``get" versus other operators *}

text{* Currently, ``get" is just function application.  While the next
properties are immediate consequences of the definitions, it is worth stating
them because of their abstract character (since later, concrete terms
inferred from abstract terms by a presumptive package, ``get" will no longer
be function application). *}

theorem getEnv_ext:
assumes "\<And> xs x. rho xs x = rho' xs x"
shows "rho = rho'"
using assms by(simp add: ext)

theorem freshEnv_getEnv1[simp]:
"\<lbrakk>freshEnv ys y rho; rho xs x = Some X\<rbrakk> \<Longrightarrow> ys \<noteq> xs \<or> y \<noteq> x"
unfolding freshEnv_def by auto

theorem freshEnv_getEnv2[simp]:
"\<lbrakk>freshEnv ys y rho; rho xs x = Some X\<rbrakk> \<Longrightarrow> fresh ys y X"
unfolding freshEnv_def liftAll_def by simp

theorem freshEnv_getEnv[simp]:
"freshEnv ys y rho \<Longrightarrow> rho ys y = None"
unfolding freshEnv_def by simp

theorem getEnv_swapEnv1[simp]:
assumes "rho xs (x @xs [z1 \<and> z2]_zs) = None"
shows "(rho &[z1 \<and> z2]_zs) xs x = None"
using assms unfolding swapEnv_defs lift_def by simp

theorem getEnv_swapEnv2[simp]:
assumes "rho xs (x @xs [z1 \<and> z2]_zs) = Some X"
shows "(rho &[z1 \<and> z2]_zs) xs x = Some (X #[z1 \<and> z2]_zs)"
using assms unfolding swapEnv_defs lift_def by simp

theorem getEnv_psubstEnv_None[simp]:
assumes "rho xs x = None"
shows "(rho &[rho']) xs x = rho' xs x"
using assms unfolding psubstEnv_def by simp

theorem getEnv_psubstEnv_Some[simp]:
assumes "rho xs x = Some X"
shows "(rho &[rho']) xs x = Some (X #[rho'])"
using assms unfolding psubstEnv_def by simp

theorem getEnv_substEnv1[simp]:
assumes "ys \<noteq> xs \<or> y \<noteq> x" and "rho xs x = None"
shows "(rho &[Y / y]_ys) xs x = None"
using assms unfolding substEnv_def2 by auto

theorem getEnv_substEnv2[simp]:
assumes "ys \<noteq> xs \<or> y \<noteq> x" and "rho xs x = Some X"
shows "(rho &[Y / y]_ys) xs x = Some (X #[Y / y]_ys)"
using assms unfolding substEnv_def2 by auto

theorem getEnv_substEnv3[simp]:
"\<lbrakk>ys \<noteq> xs \<or> y \<noteq> x; freshEnv xs x rho\<rbrakk>
 \<Longrightarrow> (rho &[Y / y]_ys) xs x = None"
apply(rule getEnv_substEnv1) by auto

theorem getEnv_substEnv4[simp]:
"freshEnv ys y rho \<Longrightarrow> (rho &[Y / y]_ys) ys y = Some Y"
unfolding substEnv_psubstEnv_idEnv by simp

theorem getEnv_vsubstEnv1[simp]:
assumes "ys \<noteq> xs \<or> y \<noteq> x" and "rho xs x = None"
shows "(rho &[y1 // y]_ys) xs x = None"
using assms unfolding vsubstEnv_def by auto

theorem getEnv_vsubstEnv2[simp]:
assumes "ys \<noteq> xs \<or> y \<noteq> x" and "rho xs x = Some X"
shows "(rho &[y1 // y]_ys) xs x = Some (X #[y1 // y]_ys)"
using assms unfolding vsubstEnv_def vsubst_def by auto

theorem getEnv_vsubstEnv3[simp]:
"\<lbrakk>ys \<noteq> xs \<or> y \<noteq> x; freshEnv xs x rho\<rbrakk>
 \<Longrightarrow> (rho &[z // y]_ys) xs x = None"
apply(rule getEnv_vsubstEnv1) by auto

theorem getEnv_vsubstEnv4[simp]:
"freshEnv ys y rho \<Longrightarrow> (rho &[z // y]_ys) ys y = Some (Var ys z)"
unfolding vsubstEnv_psubstEnv_idEnv by simp

subsection {* Substitution versus other operators  *}

definition freshImEnvAt ::
"'varSort \<Rightarrow> 'var \<Rightarrow> ('index,'bindex,'varSort,'var,'opSym)env \<Rightarrow> 'varSort \<Rightarrow> 'var \<Rightarrow> bool"
where
"freshImEnvAt xs x rho ys y ==
 rho ys y = None \<and> (ys \<noteq> xs \<or> y \<noteq> x) \<or>
 (\<exists> Y. rho ys y = Some Y \<and> fresh xs x Y)"

lemma freshAll_psubstAll:
fixes X::"('index,'bindex,'varSort,'var,'opSym)term" and
      A::"('index,'bindex,'varSort,'var,'opSym)abs" and
      P::"('index,'bindex,'varSort,'var,'opSym)param" and x
assumes goodP: "goodPar P"
shows
"(good X \<longrightarrow> z \<in> varsOf P \<longrightarrow>
  (\<forall> rho \<in> envsOf P.
     fresh zs z (X #[rho]) =
     (\<forall> ys. \<forall> y. fresh ys y X \<or> freshImEnvAt zs z rho ys y)))
 \<and>
 (goodAbs A \<longrightarrow> z \<in> varsOf P \<longrightarrow>
  (\<forall> rho \<in> envsOf P.
     freshAbs zs z (A $[rho]) =
     (\<forall> ys. \<forall> y. freshAbs ys y A \<or> freshImEnvAt zs z rho ys y)))"
apply(rule term_induct_fresh[of P])
apply(tactic {* clarify_all_tac @{context}*})
using goodP apply simp
using goodP apply (simp_all add: conjI)
unfolding psubstInp_def psubstBinp_def freshInp_def freshBinp_def
apply(tactic {* clarify_all_tac @{context}*})  unfolding liftAll_lift_comp
proof-
  fix ys y rho
  assume "rho \<in> envsOf P"
  hence "goodEnv rho" using goodP by simp
  thus "fresh zs z (psubst rho (Var ys y)) = freshImEnvAt zs z rho ys y"
  unfolding freshImEnvAt_def
  by(cases "ys = zs \<and> y = z", (cases "rho ys y", auto)+)
next
  fix inp binp rho
  assume good_inp: "goodInp inp"  "goodBinp binp"
  and *: "liftAll (\<lambda>X. \<forall>rho\<in>envsOf P. fresh zs z (psubst rho X) =
                  (\<forall>ys y. fresh ys y X \<or> freshImEnvAt zs z rho ys y)) inp"
  and **: "liftAll (\<lambda>A. \<forall>rho\<in>envsOf P. freshAbs zs z (psubstAbs rho A) =
                   (\<forall>ys y. freshAbs ys y A \<or> freshImEnvAt zs z rho ys y)) binp"
  and P: "z \<in> varsOf P" "rho \<in> envsOf P"
  let ?L1 = "liftAll (fresh zs z \<circ> psubst rho) inp"
  let ?L2 = "liftAll (freshAbs zs z \<circ> psubstAbs rho) binp"
  let ?R1 = "%ys y. liftAll (fresh ys y) inp"
  let ?R2 = "%ys y. liftAll (freshAbs ys y) binp"
  let ?R3 = "%ys y. freshImEnvAt zs z rho ys y"
  have "?L1 = (\<forall>ys. \<forall>y. ?R1 ys y \<or> ?R3 ys y)"
  using * P unfolding liftAll_def by force
  moreover
  have "?L2 = (\<forall>ys. \<forall>y. ?R2 ys y \<or> ?R3 ys y)"
  using ** P unfolding liftAll_def by force
  ultimately show "(?L1 \<and> ?L2) = (\<forall>ys y. ?R1 ys y \<and> ?R2 ys y \<or> ?R3 ys y)"
  by blast
next
  fix xs x and X::"('index,'bindex,'varSort,'var,'opSym)term" and
      P::"('index,'bindex,'varSort,'var,'opSym)param" and
      rho::"('index,'bindex,'varSort,'var,'opSym)env"
  assume good_X: "good X"
  assume "z \<in> varsOf P" and "x \<notin> varsOf P"
  hence z_diff_x: "z \<noteq> x" by auto
  assume "rho \<in> envsOf P"   "\<And>rho. rho \<in> envsOf P \<Longrightarrow> freshEnv xs x rho"
  hence x_fresh_rho: "freshEnv xs x rho" by simp
  let ?phi = "\<lambda> ys. \<lambda> y. fresh ys y X \<or> freshImEnvAt zs z rho ys y"
  let ?Left = "zs = xs \<and> z = x \<or> (\<forall>ys. \<forall>y. ?phi ys y)"
  let ?Right = "\<forall>ys. \<forall>y. ys = xs \<and> y = x \<or> ?phi ys y"
  show "?Left = ?Right" using z_diff_x
  proof(auto)
    fix ys y
    assume *: "\<forall>ys y. (ys = xs \<and> y = x) \<or> fresh ys y X \<or> freshImEnvAt zs z rho ys y"
           and **: "\<not> freshImEnvAt zs z rho ys y"
    {assume ***: "ys = xs"  "y = x"
     have False
     proof(cases "rho xs x")
       assume "rho xs x = None"
       hence "freshImEnvAt zs z rho ys y"
       unfolding *** freshImEnvAt_def using z_diff_x by simp
       thus False using ** by blast
     next
       fix X assume "rho xs x = Some X"
       thus False using x_fresh_rho unfolding freshEnv_def by auto
     qed
    }
    thus "fresh ys y X" using * ** by blast
  qed
qed

corollary fresh_psubst:
assumes "good X" and "goodEnv rho"
shows
"fresh zs z (X #[rho]) =
 (\<forall> ys y. fresh ys y X \<or> freshImEnvAt zs z rho ys y)"
using assms freshAll_psubstAll[of "Par [z] [] [] [rho]"]
unfolding goodPar_def by simp

corollary fresh_psubst_E1:
assumes "good X" and "goodEnv rho"
and "rho ys y = None" and "fresh zs z (X #[rho])"
shows "fresh ys y X \<or> (ys \<noteq> zs \<or> y \<noteq> z)"
using assms fresh_psubst unfolding freshImEnvAt_def by fastforce

corollary fresh_psubst_E2:
assumes "good X" and "goodEnv rho"
and "rho ys y = Some Y" and "fresh zs z (X #[rho])"
shows "fresh ys y X \<or> fresh zs z Y"
using assms fresh_psubst[of X rho] unfolding freshImEnvAt_def by fastforce

corollary fresh_psubst_I1:
assumes "good X" and "goodEnv rho"
and "fresh zs z X" and "freshEnv zs z rho"
shows "fresh zs z (X #[rho])"
using assms apply(simp add: fresh_psubst)
unfolding freshEnv_def liftAll_def freshImEnvAt_def by auto

corollary psubstEnv_preserves_freshEnv:
assumes good: "goodEnv rho"  "goodEnv rho'"
and fresh: "freshEnv zs z rho"  "freshEnv zs z rho'"
shows "freshEnv zs z (rho &[rho'])"
unfolding freshEnv_def liftAll_def proof auto
  have "rho zs z = None \<and> rho' zs z = None"
  using fresh unfolding freshEnv_def by auto
  thus "(rho &[rho']) zs z = None" unfolding psubstEnv_def by simp
next
  fix ys y Y assume *: "(rho &[rho']) ys y = Some Y"
  show "fresh zs z Y"
  proof(cases "rho ys y")
    assume Case1: "rho ys y = None"
    hence "rho' ys y = Some Y" using * unfolding psubstEnv_def by simp
    thus ?thesis using fresh unfolding freshEnv_def liftAll_def by simp
  next
    fix X assume Case2: "rho ys y = Some X"
    hence "good X \<and> fresh zs z X"
    using good fresh unfolding goodEnv_def freshEnv_def liftAll_def by simp
    moreover have "Y = (X #[rho'])" using * Case2 unfolding psubstEnv_def by simp
    ultimately show ?thesis using good fresh fresh_psubst_I1 by auto
  qed
qed

corollary fresh_psubst_I:
assumes "good X" and "goodEnv rho"
and "rho zs z = None \<Longrightarrow> fresh zs z X" and
    "\<And> ys y Y. rho ys y = Some Y \<Longrightarrow> fresh ys y X \<or> fresh zs z Y"
shows "fresh zs z (X #[rho])"
using assms apply(simp add: fresh_psubst)
unfolding freshImEnvAt_def apply auto
proof-
  fix ys y
  assume *: "\<And>ys y Y. rho ys y = Some Y \<Longrightarrow> fresh ys y X \<or> fresh zs z Y"
  "\<not> fresh ys y X" "\<forall>Y. rho ys y = Some Y \<longrightarrow> \<not> fresh zs z Y"
  {fix Y assume "rho ys y = Some Y"
   hence False using * by auto
  }
  thus "rho ys y = None" by fastforce
qed

lemma fresh_subst:
assumes "good X" and "good Y"
shows "fresh zs z (X #[Y / y]_ys) =
       (((zs = ys \<and> z = y) \<or> fresh zs z X) \<and> (fresh ys y X \<or> fresh zs z Y))"
unfolding subst_def
using assms apply(simp add: fresh_psubst)
unfolding freshImEnvAt_def by auto

lemma fresh_vsubst:
assumes "good X"
shows "fresh zs z (X #[y1 // y]_ys) =
       (((zs = ys \<and> z = y) \<or> fresh zs z X) \<and> (fresh ys y X \<or> (zs \<noteq> ys \<or> z \<noteq> y1)))"
unfolding vsubst_def using assms by(auto simp add: fresh_subst)

lemma subst_preserves_fresh:
assumes "good X" and "good Y"
and "fresh zs z X" and "fresh zs z Y"
shows "fresh zs z (X #[Y / y]_ys)"
using assms by(simp add: fresh_subst)

lemma substEnv_preserves_freshEnv_aux:
assumes rho: "goodEnv rho" and Y: "good Y"
and fresh_rho: "freshEnv zs z rho" and fresh_Y: "fresh zs z Y" and diff: "zs \<noteq> ys \<or> z \<noteq> y"
shows "freshEnv zs z (rho &[Y / y]_ys)"
unfolding freshEnv_def liftAll_def apply auto
proof-
  show "(rho &[Y / y]_ys) zs z = None"
  unfolding substEnv_def2 apply(cases "rho zs z") apply(simp_all add: assms)
  using diff by auto
next
  let ?rhoYy = "rho &[Y / y]_ys"
  fix xs x Z assume *: "?rhoYy xs x = Some Z"
  moreover have rhoYy: "goodEnv ?rhoYy" using assms by simp
  ultimately have Z: "good Z"
  unfolding goodEnv_def liftAll_def by fastforce+
  show "fresh zs z Z"
  proof(cases "rho xs x")
    assume Case1: "rho xs x = None"
    show ?thesis
    proof(cases "xs = ys \<and> x = y")
      assume Case11: "xs = ys \<and> x = y"
      hence "?rhoYy xs x = Some Y"
      unfolding substEnv_def2 using Case1 by simp
      hence "Z = Y" using * by simp
      thus ?thesis using fresh_Y by simp
    next
      assume Case12: "\<not> (xs = ys \<and> x = y)"
      hence "?rhoYy xs x = None"
      unfolding substEnv_def2 using Case1 by simp
      thus ?thesis using * by simp
    qed
  next
    fix X assume Case2: "rho xs x = Some X"
    hence fresh_X: "fresh zs z X"
    using fresh_rho unfolding freshEnv_def liftAll_def by simp
    have X: "good X" using Case2 rho unfolding goodEnv_def liftAll_def by auto
    have "?rhoYy xs x = Some (X #[Y / y]_ys)"
    unfolding substEnv_def2 using Case2 by simp
    hence Z_eq: "Z = X #[Y / y]_ys" using * by simp
    show ?thesis unfolding Z_eq
    using assms X fresh_X by(simp add: subst_preserves_fresh)
  qed
qed

lemma substEnv_preserves_freshEnv:
assumes rho: "goodEnv rho" and Y: "good Y"
and fresh_rho: "freshEnv zs z rho" and fresh_Y: "fresh zs z Y" and diff: "zs \<noteq> ys \<or> z \<noteq> y"
shows "freshEnv zs z (rho &[Y / y]_ys)"
using assms by(simp add: substEnv_preserves_freshEnv_aux)

lemma vsubst_preserves_fresh:
assumes "good X"
and "fresh zs z X" and "zs \<noteq> ys \<or> z \<noteq> y1"
shows "fresh zs z (X #[y1 // y]_ys)"
using assms by(simp add: fresh_vsubst)

lemma vsubstEnv_preserves_freshEnv:
assumes rho: "goodEnv rho"
and fresh_rho: "freshEnv zs z rho" and diff: "zs \<noteq> ys \<or> z \<notin> {y,y1}"
shows "freshEnv zs z (rho &[y1 // y]_ys)"
using assms unfolding vsubstEnv_def
by(simp add: substEnv_preserves_freshEnv)

lemma fresh_fresh_subst[simp]:
assumes "good Y" and "good X"
and "fresh ys y Y"
shows "fresh ys y (X #[Y / y]_ys)"
using assms by(simp add: fresh_subst)

lemma diff_fresh_vsubst[simp]:
assumes "good X"
and "y \<noteq> y1"
shows "fresh ys y (X #[y1 // y]_ys)"
using assms by(simp add: fresh_vsubst)

lemma fresh_subst_E1:
assumes "good X" and "good Y"
and "fresh zs z (X #[Y / y]_ys)" and "zs \<noteq> ys \<or> z \<noteq> y"
shows "fresh zs z X"
using assms by(auto simp add: fresh_subst)

lemma fresh_vsubst_E1:
assumes "good X"
and "fresh zs z (X #[y1 // y]_ys)" and "zs \<noteq> ys \<or> z \<noteq> y"
shows "fresh zs z X"
using assms by(auto simp add: fresh_vsubst)

lemma fresh_subst_E2:
assumes "good X" and "good Y"
and "fresh zs z (X #[Y / y]_ys)"
shows "fresh ys y X \<or> fresh zs z Y"
using assms by(simp add: fresh_subst)

lemma fresh_vsubst_E2:
assumes "good X"
and "fresh zs z (X #[y1 // y]_ys)"
shows "fresh ys y X \<or> zs \<noteq> ys \<or> z \<noteq> y1"
using assms by(simp add: fresh_vsubst)

lemma psubstAll_cong:
fixes X::"('index,'bindex,'varSort,'var,'opSym)term" and
      A::"('index,'bindex,'varSort,'var,'opSym)abs" and
      P::"('index,'bindex,'varSort,'var,'opSym)param"
assumes goodP: "goodPar P"
shows
"(good X \<longrightarrow>
  (\<forall> rho rho'. {rho, rho'} \<subseteq> envsOf P \<longrightarrow>
   (\<forall> ys. \<forall> y. fresh ys y X \<or> rho ys y = rho' ys y) \<longrightarrow>
               (X #[rho]) = (X #[rho'])))
\<and>
 (goodAbs A \<longrightarrow>
  (\<forall> rho rho'. {rho, rho'} \<subseteq> envsOf P \<longrightarrow>
   (\<forall> ys. \<forall> y. freshAbs ys y A \<or> rho ys y = rho' ys y) \<longrightarrow>
               (A $[rho]) = (A $[rho'])))"
apply(rule term_induct_fresh[of P])
using goodP apply(tactic {* clarify_all_tac @{context}*}, simp_all)
unfolding psubstInp_def psubstBinp_def freshInp_def freshBinp_def
goodInp_def goodBinp_def
apply(tactic {* clarify_all_tac @{context}*})
proof-
  fix xs and s::'sort and x
  and rho rho' :: "('index,'bindex,'varSort,'var,'opSym)env"
  assume "rho \<in> envsOf P" and "rho' \<in> envsOf P"
  hence goodEnv: "goodEnv rho \<and> goodEnv rho'" using goodP by simp
  assume 1: "rho xs x = rho' xs x"
  thus "((Var xs x) #[rho]) = ((Var xs x) #[rho'])"
  using goodEnv proof(cases "rho xs x", force)
    fix X assume "rho xs x = Some X"
    thus ?thesis using 1 goodEnv by auto
  qed
next
  fix delta and inp::"('index,('index,'bindex,'varSort,'var,'opSym)term)input"
  and binp::"('bindex,('index,'bindex,'varSort,'var,'opSym)abs)input"
  and rho rho' :: "('index,'bindex,'varSort,'var,'opSym)env"
  assume envs: "rho \<in> envsOf P"  "rho' \<in> envsOf P"
  hence goodEnv: "goodEnv rho \<and> goodEnv rho'" using goodP by simp
  let ?phi = "\<lambda>rho rho' X. (\<forall>ys y. fresh ys y X \<or> rho ys y = rho' ys y) \<longrightarrow>
                           (X #[rho]) = (X #[rho'])"
  let ?phiAbs = "\<lambda>rho rho' A. (\<forall>ys y. freshAbs ys y A \<or> rho ys y = rho' ys y) \<longrightarrow>
                               (A $[rho]) = (A $[rho'])"
  let ?chi = "\<lambda>rho rho' X. rho \<in> envsOf P \<and> rho' \<in> envsOf P \<longrightarrow> ?phi rho rho' X"
  let ?chiAbs = "\<lambda>rho rho' A. rho \<in> envsOf P \<and> rho' \<in> envsOf P \<longrightarrow> ?phiAbs rho rho' A"
  assume "\<forall>ys y. (liftAll (fresh ys y) inp \<and> liftAll (freshAbs ys y) binp)
                          \<or> rho ys y = rho' ys y"
  hence 1: "liftAll (\<lambda> X. \<forall>ys y. fresh ys y X \<or> rho ys y = rho' ys y) inp \<and>
            liftAll (\<lambda> A. \<forall>ys y. freshAbs ys y A \<or> rho ys y = rho' ys y) binp"
  unfolding liftAll_def by blast
  have "(\<forall> X. (\<forall> rho rho'. ?chi rho rho' X) \<longrightarrow> ?phi rho rho' X) \<and>
        (\<forall> A. (\<forall> rho rho'. ?chiAbs rho rho' A) \<longrightarrow> ?phiAbs rho rho' A)" using envs by blast
  moreover assume "liftAll (\<lambda> X. \<forall> rho rho'. ?chi rho rho' X) inp" and
                  "liftAll (\<lambda> A. \<forall> rho rho'. ?chiAbs rho rho' A) binp"
  ultimately have liftAll: "liftAll (?phi rho rho') inp \<and>
                            liftAll (?phiAbs rho rho') binp"
  using liftAll_mono[of "\<lambda>X. \<forall> rho rho'. ?chi rho rho' X" "?phi rho rho'" inp]
        liftAll_mono[of "\<lambda>A. \<forall> rho rho'. ?chiAbs rho rho' A" "?phiAbs rho rho'" binp] by simp
  hence "liftAll (\<lambda> X. (X #[rho]) = (X #[rho'])) inp \<and>
         liftAll (\<lambda> A. (A $[rho]) = (A $[rho'])) binp"
  apply auto using 1 liftAll_mp by fastforce+
  thus "lift (psubst rho) inp = lift (psubst rho') inp \<and>
        lift (psubstAbs rho) binp = lift (psubstAbs rho') binp"
  apply auto using liftAll_lift_ext by auto
next
  fix xs x
  and X::"('index,'bindex,'varSort,'var,'opSym)term"
  and rho rho' :: "('index,'bindex,'varSort,'var,'opSym)env"
  assume envs: "rho \<in> envsOf P"   "rho' \<in> envsOf P"
  assume "\<And>rho. rho \<in> envsOf P \<Longrightarrow> freshEnv xs x rho"
  with envs have fresh: "freshEnv xs x rho"  "freshEnv xs x rho'" by auto
  assume *: "\<forall>ys y. ys = xs \<and> y = x \<or> fresh ys y X \<or> rho ys y = rho' ys y"
  have "\<forall>ys y. fresh ys y X \<or> rho ys y = rho' ys y"
  proof(intro allI ballI)
    fix ys y
    {fix Y Y' assume "(rho ys y = Some Y) \<or> (rho' ys y = Some Y')"
     hence "\<not> (ys = xs \<and> y = x)" using fresh unfolding freshEnv_def liftAll_def by auto
     hence "fresh ys y X \<or> rho ys y = rho' ys y" using * by blast
    }
    thus "fresh ys y X \<or> rho ys y = rho' ys y" by fastforce
  qed
  moreover
  assume IH: "\<forall>rho rho'. rho \<in> envsOf P \<and> rho' \<in> envsOf P \<longrightarrow>
                 (\<forall>ys y. fresh ys y X \<or> rho ys y = rho' ys y) \<longrightarrow>
                 (X #[rho]) = (X #[rho'])"
  ultimately have "(X #[rho]) = (X #[rho'])"  using envs by blast
  thus "Abs xs x (psubst rho X) = Abs xs x (psubst rho' X)" by simp
qed

corollary psubst_cong[fundef_cong]:
assumes "good X" and "goodEnv rho" and "goodEnv rho'"
and "\<And> ys y. fresh ys y X \<or> rho ys y = rho' ys y"
shows "(X #[rho]) = (X #[rho'])"
using assms psubstAll_cong[of "Par [] [] [] [rho,rho']"]
unfolding goodPar_def by simp

(* Note: A congruence principle for ``psubstEnv" would not hold w.r.t. ``freshEnv",
and the one that would hold w.r.t. ``fresh" would be a mere rephrazing of the
definition of ``psubstEnv", not worth stating. *)

lemma fresh_psubst_updEnv:
assumes "good X" and "good Y" and "goodEnv rho"
and "fresh xs x Y"
shows "(Y #[rho [x \<leftarrow> X]_xs]) = (Y #[rho])"
apply(rule psubst_cong)
using assms by auto

lemma psubstAll_ident:
fixes X :: "('index,'bindex,'varSort,'var,'opSym)term" and
      A :: "('index,'bindex,'varSort,'var,'opSym)abs" and
      P :: "('index,'bindex,'varSort,'var,'opSym) Transition_QuasiTerms_Terms.param"
assumes P: "goodPar P"
shows
"(good X \<longrightarrow>
  (\<forall> rho \<in> envsOf P.
   (\<forall> zs z. freshEnv zs z rho \<or> fresh zs z X)
   \<longrightarrow> (X #[rho]) = X))
 \<and>
 (goodAbs A \<longrightarrow>
  (\<forall> rho \<in> envsOf P.
   (\<forall> zs z. freshEnv zs z rho \<or> freshAbs zs z A)
   \<longrightarrow> (A $[rho]) = A))"
apply(rule term_induct_fresh)
apply(tactic {* mauto_no_simp_tac @{context} *}) using P apply simp_all
prefer 3 apply fastforce
proof-
  fix xs x rho
  assume "rho \<in> envsOf P"
  and "\<forall>z. freshEnv xs z rho \<or> z \<noteq> x"
  with P show "psubst rho (Var xs x) = Var xs x"
  apply(case_tac "rho xs x", simp_all)
  unfolding freshEnv_def liftAll_def by force
next
  fix inp binp rho
  assume inps: "goodInp inp"  "goodBinp binp"
  and *:
  "liftAll
     (\<lambda>X. \<forall>rho\<in>envsOf P. (\<forall>zs z. freshEnv zs z rho \<or> fresh zs z X) \<longrightarrow> psubst rho X = X) inp"
  and **:
  "liftAll
     (\<lambda>A. \<forall>rho\<in>envsOf P. (\<forall>zs z. freshEnv zs z rho \<or> freshAbs zs z A) \<longrightarrow> psubstAbs rho A = A) binp"
  and rho: "rho \<in> envsOf P"
  and ***: "\<forall>zs z. freshEnv zs z rho \<or> freshInp zs z inp \<and> freshBinp zs z binp"
  show "psubstInp rho inp = inp \<and> psubstBinp rho binp = binp"
  unfolding psubstInp_def psubstBinp_def lift_def
  apply auto
  proof-
    show "(\<lambda>i. case inp i of None \<Rightarrow> None | Some X \<Rightarrow> Some (psubst rho X)) = inp"
    proof(rule ext, case_tac "inp i", simp_all)
      fix i X assume inpi: "inp i = Some X"
      hence "\<forall>zs z. freshEnv zs z rho \<or> fresh zs z X"
      using *** unfolding freshInp_def liftAll_def by auto
      thus "psubst rho X = X" using P rho inpi * unfolding liftAll_def by simp
    qed
  next
    show "(\<lambda>i. case binp i of None \<Rightarrow> None | Some A \<Rightarrow> Some (psubstAbs rho A)) = binp"
    proof(rule ext, case_tac "binp i", simp_all)
      fix i A assume binpi: "binp i = Some A"
      hence "\<forall>zs z. freshEnv zs z rho \<or> freshAbs zs z A"
      using *** unfolding freshBinp_def liftAll_def by auto
      thus "psubstAbs rho A = A" using P rho binpi ** unfolding liftAll_def by simp
    qed
  qed
qed

corollary freshEnv_psubst_ident[simp]:
fixes X :: "('index,'bindex,'varSort,'var,'opSym)term"
assumes "good X" and "goodEnv rho"
and "\<And> zs z. freshEnv zs z rho \<or> fresh zs z X"
shows "(X #[rho]) = X"
using assms
psubstAll_ident[of "Par [] [] [] [rho]"]
unfolding goodPar_def by simp

lemma fresh_subst_ident[simp]:
assumes "good X" and "good Y" and "fresh xs x Y"
shows "(Y #[X / x]_xs) = Y"
proof-
  have "(Y #[X / x]_xs) = (Y #[idEnv])"
  unfolding subst_def apply(rule fresh_psubst_updEnv)
  using assms by auto
  thus ?thesis using assms psubst_idEnv by auto
qed

corollary substEnv_updEnv_fresh:
assumes "good X" and "good Y" and "fresh ys y X"
shows "((rho [x \<leftarrow> X]_xs) &[Y / y]_ys) = ((rho &[Y / y]_ys) [x \<leftarrow> X]_xs)"
using assms by(auto simp add: fresh_subst_ident substEnv_updEnv)

lemma fresh_substEnv_updEnv[simp]:
assumes rho: "goodEnv rho" and Y: "good Y"
and *: "freshEnv ys y rho"
shows "(rho &[Y / y]_ys) = (rho [y \<leftarrow> Y]_ys)"
apply (rule getEnv_ext) using assms apply simp_all apply clarify
proof-
  fix xs x
  assume diff: "xs = ys \<longrightarrow> x \<noteq> y"
  show "(rho &[Y / y]_ys) xs x = rho xs x"
  proof(cases "rho xs x")
    assume Case1: "rho xs x = None"
    hence "(rho &[Y / y]_ys) xs x = None"
    using diff getEnv_substEnv3 by auto
    thus ?thesis using Case1 by simp
  next
    fix X assume Case2: "rho xs x = Some X"
    hence "fresh ys y X" using * unfolding freshEnv_def liftAll_def by auto
    moreover have "good X" using rho Case2 by simp
    ultimately have "(X #[Y / y]_ys) = X" using Y by simp
    hence "(rho &[Y / y]_ys) xs x = Some X"
    using Case2 diff getEnv_substEnv2 by auto
    thus ?thesis using Case2 by simp
  qed
qed

lemma fresh_vsubst_ident[simp]:
assumes "good Y" and "fresh xs x Y"
shows "(Y #[x1 // x]_xs) = Y"
using assms unfolding vsubst_def by(auto simp add: fresh_subst_ident)

corollary vsubstEnv_updEnv_fresh:
assumes "good X" and "fresh ys y X"
shows "((rho [x \<leftarrow> X]_xs) &[y1 // y]_ys) = ((rho &[y1 // y]_ys) [x \<leftarrow> X]_xs)"
using assms by(auto simp add: fresh_vsubst_ident vsubstEnv_updEnv)

lemma fresh_vsubstEnv_updEnv[simp]:
assumes rho: "goodEnv rho"
and *: "freshEnv ys y rho"
shows "(rho &[y1 // y]_ys) = (rho [y \<leftarrow> Var ys y1]_ys)"
using assms unfolding vsubstEnv_def by simp

lemma swapAll_psubstAll:
fixes X::"('index,'bindex,'varSort,'var,'opSym)term" and
      A::"('index,'bindex,'varSort,'var,'opSym)abs" and
      P::"('index,'bindex,'varSort,'var,'opSym)param"
assumes P: "goodPar P"
shows
"(good X \<longrightarrow>
  (\<forall> rho z1 z2. rho \<in> envsOf P \<and> {z1,z2} \<subseteq> varsOf P \<longrightarrow>
                ((X #[rho]) #[z1 \<and> z2]_zs) = ((X #[z1 \<and> z2]_zs) #[rho &[z1 \<and> z2]_zs])))
 \<and>
 (goodAbs A \<longrightarrow>
  (\<forall> rho z1 z2. rho \<in> envsOf P \<and> {z1,z2} \<subseteq> varsOf P \<longrightarrow>
                ((A $[rho]) $[z1 \<and> z2]_zs) = ((A $[z1 \<and> z2]_zs) $[rho &[z1 \<and> z2]_zs])))"
apply(rule term_induct_fresh[of P])
using P apply simp
(*  *)
apply clarify
using P apply(case_tac "rho xs x", force)
(*  *)
using P apply auto
using P
unfolding psubstInp_def swapInp_def psubstBinp_def swapBinp_def lift_comp
unfolding liftAll_def lift_def apply -
apply(rule ext, case_tac "inp i", force, force)
apply(rule ext, case_tac "binp i", force, force)
done

lemma swap_psubst:
assumes "good X" and "goodEnv rho"
shows "((X #[rho]) #[z1 \<and> z2]_zs) = ((X #[z1 \<and> z2]_zs) #[rho &[z1 \<and> z2]_zs])"
using assms swapAll_psubstAll[of "Par [z1,z2] [] [] [rho]"]
unfolding goodPar_def by auto

lemma swap_subst:
assumes "good X" and "good Y"
shows "((X #[Y / y]_ys) #[z1 \<and> z2]_zs) =
       ((X #[z1 \<and> z2]_zs) #[(Y #[z1 \<and> z2]_zs) / (y @ys[z1 \<and> z2]_zs)]_ys)"
proof-
  have 1: "(idEnv [(y @ys[z1 \<and> z2]_zs) \<leftarrow> (Y #[z1 \<and> z2]_zs)]_ys) =
           ((idEnv [y \<leftarrow> Y]_ys) &[z1 \<and> z2]_zs)"
  by(simp add: swapEnv_updEnv)
  show ?thesis
  unfolding subst_def 1 apply (rule swap_psubst)
  using assms by auto
qed

lemma swap_vsubst:
assumes "good X"
shows "((X #[y1 // y]_ys) #[z1 \<and> z2]_zs) =
       ((X #[z1 \<and> z2]_zs) #[(y1 @ys[z1 \<and> z2]_zs) // (y @ys[z1 \<and> z2]_zs)]_ys)"
using assms unfolding vsubst_def
by(simp add: swap_subst)

lemma swapEnv_psubstEnv:
assumes "goodEnv rho" and "goodEnv rho'"
shows "((rho &[rho']) &[z1 \<and> z2]_zs) = ((rho &[z1 \<and> z2]_zs) &[rho' &[z1 \<and> z2]_zs])"
proof (rule ext)+
  fix x xs
  let ?xsw = "x @xs[z1 \<and> z2]_zs"
  let ?rhosw = "rho &[z1 \<and> z2]_zs"  let ?rho'sw = "rho' &[z1 \<and> z2]_zs"
  let ?rhorho' = "rho &[rho']"  let ?rhosw_rho'sw = "?rhosw &[?rho'sw]"
  let ?rhorho'_sw = "?rhorho' &[z1 \<and> z2]_zs"
  let ?Sw = "\<lambda>X. X #[z1 \<and> z2]_zs"
  show "?rhorho'_sw xs x = ?rhosw_rho'sw xs x"
  proof(cases "rho xs ?xsw")
    assume Case1: "rho xs ?xsw = None"
    thus ?thesis
    unfolding swapEnv_defs psubstEnv_def lift_def by auto
  next
    fix X assume Case2: "rho xs ?xsw = Some X"
    hence "good X" using assms unfolding goodEnv_def liftAll_def by auto
    have "?rhorho'_sw xs x = Some ((X #[rho']) #[z1 \<and> z2]_zs)"
    using Case2 unfolding swapEnv_defs psubstEnv_def lift_def by auto
    also have "\<dots> = Some ((?Sw X) #[?rho'sw])"
    using `good X` assms by(auto simp add: swap_psubst)
    also have "\<dots> = ?rhosw_rho'sw xs x"
    using Case2 unfolding swapEnv_defs psubstEnv_def lift_def by auto
    finally show ?thesis .
  qed
qed

lemma swapEnv_substEnv:
assumes "good Y" and "goodEnv rho"
shows "((rho &[Y / y]_ys) &[z1 \<and> z2]_zs) =
       ((rho &[z1 \<and> z2]_zs) &[(Y #[z1 \<and> z2]_zs) / (y @ys[z1 \<and> z2]_zs)]_ys)"
proof-
  have 1: "(idEnv [(y @ys[z1 \<and> z2]_zs) \<leftarrow> (Y #[z1 \<and> z2]_zs)]_ys) =
           ((idEnv [y \<leftarrow> Y]_ys) &[z1 \<and> z2]_zs)"
  by(simp add: swapEnv_updEnv)
  show ?thesis
  unfolding substEnv_def 1 apply (rule swapEnv_psubstEnv)
  using assms by auto
qed

lemma swapEnv_vsubstEnv:
assumes "goodEnv rho"
shows "((rho &[y1 // y]_ys) &[z1 \<and> z2]_zs) =
       ((rho &[z1 \<and> z2]_zs) &[(y1 @ys[z1 \<and> z2]_zs) // (y @ys[z1 \<and> z2]_zs)]_ys)"
using assms unfolding vsubstEnv_def by(simp add: swapEnv_substEnv)

lemma psubstAll_compose:
fixes X::"('index,'bindex,'varSort,'var,'opSym)term" and
      A::"('index,'bindex,'varSort,'var,'opSym)abs" and
      P::"('index,'bindex,'varSort,'var,'opSym)param"
assumes P: "goodPar P"
shows
"(good X \<longrightarrow>
  (\<forall> rho rho'. {rho,rho'} \<subseteq> envsOf P \<longrightarrow> ((X #[rho]) #[rho']) = (X #[(rho &[rho'])])))
\<and>
 (goodAbs A \<longrightarrow>
  (\<forall> rho rho'. {rho,rho'} \<subseteq> envsOf P \<longrightarrow> ((A $[rho]) $[rho']) = (A $[(rho &[rho'])])))"
apply(rule term_induct_fresh[of P])
using P
apply(simp_all add: psubstEnv_preserves_freshEnv)
prefer 2
unfolding psubstInp_def swapInp_def psubstBinp_def swapBinp_def lift_comp
unfolding liftAll_def lift_def apply clarsimp apply(intro conjI)
apply(rule ext, case_tac "inp i", force, force)
apply(rule ext, case_tac "binp i", force, force)
proof clarsimp
  fix xs x
  and rho rho' :: "('index,'bindex,'varSort,'var,'opSym)env"
  assume "rho \<in> envsOf P" and "rho' \<in> envsOf P"
  hence good: "goodEnv rho" "goodEnv rho'" using P by auto
  let ?Left = "((Var xs x) #[rho]) #[rho']"
  let ?Right = "(Var xs x) #[(rho &[rho'])]"
  show "?Left = ?Right"
  proof(cases "rho xs x")
    assume Case1: "rho xs x = None"
    hence "(rho &[rho']) xs x = rho' xs x" unfolding psubstEnv_def by simp
    thus ?thesis using Case1 good by(cases "rho' xs x", auto)
  next
    fix X assume Case2: "rho xs x = Some X"
    hence "(rho &[rho']) xs x = Some (X #[rho'])" unfolding psubstEnv_def by simp
    thus ?thesis using Case2 good by(cases "rho' xs x", auto)
  qed
qed

corollary psubst_compose:
assumes "good X" and "goodEnv rho" and "goodEnv rho'"
shows "((X #[rho]) #[rho']) = (X #[(rho &[rho'])])"
using assms psubstAll_compose[of "Par [] [] [] [rho, rho']"]
unfolding goodPar_def by auto

lemma psubstEnv_compose:
assumes "goodEnv rho" and "goodEnv rho'" and "goodEnv rho''"
shows "((rho &[rho']) &[rho'']) = (rho &[(rho' &[rho''])])"
proof(rule ext)+
  fix xs x
  let ?Left = "((rho &[rho']) &[rho'']) xs x"
  let ?Right = "(rho &[(rho' &[rho''])]) xs x"
  show "?Left = ?Right"
  proof(cases "rho xs x")
    assume Case1: "rho xs x = None"
    thus ?thesis unfolding psubstEnv_def by(cases "rho' xs x", auto)
  next
    fix X assume Case2: "rho xs x = Some X"
    hence "?Left = Some ((X #[rho']) #[rho''])"  unfolding psubstEnv_def by simp
    moreover have "?Right = Some (X #[(rho' &[rho''])])"
    using Case2  unfolding psubstEnv_def by simp
    moreover have "good X" using Case2 assms unfolding goodEnv_def liftAll_def by simp
    ultimately show ?thesis using psubst_compose assms by auto
  qed
qed

lemma psubst_subst_compose:
assumes "good X" and "good Y" and "goodEnv rho"
shows "((X #[Y / y]_ys) #[rho]) = (X #[(rho [y \<leftarrow> (Y #[rho])]_ys)])"
proof-
  have "goodEnv (idEnv [y \<leftarrow> Y]_ys)" using assms by simp
  thus ?thesis using assms unfolding subst_def substEnv_def
  by(simp add: psubst_compose psubstEnv_updEnv_idEnv)
qed

lemma psubstEnv_substEnv_compose:
assumes "goodEnv rho" and "good Y" and "goodEnv rho'"
shows "((rho &[Y / y]_ys) &[rho']) = (rho &[(rho' [y \<leftarrow> (Y #[rho'])]_ys)])"
proof-
  have "goodEnv (idEnv [y \<leftarrow> Y]_ys)" using assms by simp
  thus ?thesis using assms unfolding substEnv_def
  by(simp add: psubstEnv_compose psubstEnv_updEnv_idEnv)
qed

lemma psubst_vsubst_compose:
assumes "good X" and "goodEnv rho"
shows "((X #[y1 // y]_ys) #[rho]) = (X #[(rho [y \<leftarrow> ((Var ys y1) #[rho])]_ys)])"
using assms unfolding vsubst_def by(simp add: psubst_subst_compose)

lemma psubstEnv_vsubstEnv_compose:
assumes "goodEnv rho" and "goodEnv rho'"
shows "((rho &[y1 // y]_ys) &[rho']) = (rho &[(rho' [y \<leftarrow> ((Var ys y1) #[rho'])]_ys)])"
using assms unfolding vsubstEnv_def by(simp add: psubstEnv_substEnv_compose)

lemma subst_psubst_compose:
assumes "good X" and "good Y" and "goodEnv rho"
shows "((X #[rho]) #[Y / y]_ys) = (X #[(rho &[Y / y]_ys)])"
unfolding subst_def substEnv_def using assms by(simp add: psubst_compose)

lemma substEnv_psubstEnv_compose:
assumes "goodEnv rho" and "good Y" and "goodEnv rho'"
shows "((rho &[rho']) &[Y / y]_ys) = (rho &[(rho' &[Y / y]_ys)])"
unfolding substEnv_def using assms by(simp add: psubstEnv_compose)

lemma psubst_subst_compose_freshEnv:
assumes "goodEnv rho" and "good X" and "good Y"
assumes "freshEnv ys y rho"
shows "((X #[Y / y]_ys) #[rho]) = ((X #[rho]) #[(Y #[rho]) / y]_ys)"
using assms by (auto simp add: subst_psubst_compose psubst_subst_compose)

lemma psubstEnv_substEnv_compose_freshEnv:
assumes "goodEnv rho" and "goodEnv rho'" and "good Y"
assumes "freshEnv ys y rho'"
shows "((rho &[Y / y]_ys) &[rho']) = ((rho &[rho']) &[(Y #[rho']) / y]_ys)"
using assms by (simp add: substEnv_psubstEnv_compose psubstEnv_substEnv_compose)

lemma vsubst_psubst_compose:
assumes "good X" and "goodEnv rho"
shows "((X #[rho]) #[y1 // y]_ys) = (X #[(rho &[y1 // y]_ys)])"
unfolding vsubst_def vsubstEnv_def using assms by(simp add: subst_psubst_compose)

lemma vsubstEnv_psubstEnv_compose:
assumes "goodEnv rho" and "goodEnv rho'"
shows "((rho &[rho']) &[y1 // y]_ys) = (rho &[(rho' &[y1 // y]_ys)])"
unfolding vsubstEnv_def using assms by(simp add: substEnv_psubstEnv_compose)

lemma subst_compose1:
assumes "good X" and "good Y1" and "good Y2"
shows "((X #[Y1 / y]_ys) #[Y2 / y]_ys) = (X #[(Y1 #[Y2 / y]_ys) / y]_ys)"
proof-
  have "goodEnv (idEnv [y \<leftarrow> Y1]_ys) \<and> goodEnv (idEnv [y \<leftarrow> Y2]_ys)" using assms by simp
  thus ?thesis using `good X` unfolding subst_def substEnv_def
  by(simp add: psubst_compose psubstEnv_updEnv)
qed

lemma substEnv_compose1:
assumes "goodEnv rho" and "good Y1" and "good Y2"
shows "((rho &[Y1 / y]_ys) &[Y2 / y]_ys) = (rho &[(Y1 #[Y2 / y]_ys) / y]_ys)"
proof-
  have "goodEnv (idEnv [y \<leftarrow> Y1]_ys) \<and> goodEnv (idEnv [y \<leftarrow> Y2]_ys)" using assms by simp
  thus ?thesis using `goodEnv rho` unfolding subst_def substEnv_def
  by(simp add: psubstEnv_compose psubstEnv_updEnv)
qed

lemma subst_vsubst_compose1:
assumes "good X" and "good Y" and "y \<noteq> y1"
shows "((X #[y1 // y]_ys) #[Y / y]_ys) = (X #[y1 // y]_ys)"
using assms unfolding vsubst_def by(simp add: subst_compose1)

lemma substEnv_vsubstEnv_compose1:
assumes "goodEnv rho" and "good Y" and "y \<noteq> y1"
shows "((rho &[y1 // y]_ys) &[Y / y]_ys) = (rho &[y1 // y]_ys)"
using assms unfolding vsubst_def vsubstEnv_def by(simp add: substEnv_compose1)

lemma vsubst_subst_compose1:
assumes "good X" and "good Y"
shows "((X #[Y / y]_ys) #[y1 // y]_ys) = (X #[(Y #[y1 // y]_ys) / y]_ys)"
using assms unfolding vsubst_def by(simp add: subst_compose1)

lemma vsubstEnv_substEnv_compose1:
assumes "goodEnv rho" and "good Y"
shows "((rho &[Y / y]_ys) &[y1 // y]_ys) = (rho &[(Y #[y1 // y]_ys) / y]_ys)"
using assms unfolding vsubst_def vsubstEnv_def by(simp add: substEnv_compose1)

lemma vsubst_compose1:
assumes "good X"
shows "((X #[y1 // y]_ys) #[y2 // y]_ys) = (X #[(y1 @ys[y2 / y]_ys) // y]_ys)"
using assms unfolding vsubst_def apply(simp add: subst_compose1)
by(cases "y = y1", auto)

lemma vsubstEnv_compose1:
assumes "goodEnv rho"
shows "((rho &[y1 // y]_ys) &[y2 // y]_ys) = (rho &[(y1 @ys[y2 / y]_ys) // y]_ys)"
using assms unfolding vsubstEnv_def apply(simp add: substEnv_compose1)
by(cases "y = y1", auto)

lemma subst_compose2:
assumes  "good X" and "good Y" and "good Z"
and "ys \<noteq> zs \<or> y \<noteq> z" and fresh: "fresh ys y Z"
shows "((X #[Y / y]_ys) #[Z / z]_zs) = ((X #[Z / z]_zs) #[(Y #[Z / z]_zs) / y]_ys)"
proof-
  have "goodEnv (idEnv [y \<leftarrow> Y]_ys) \<and> goodEnv (idEnv [z \<leftarrow> Z]_zs)" using assms by simp
  thus ?thesis using assms unfolding subst_def substEnv_def
  apply(simp add: psubst_compose psubstEnv_updEnv)
  using fresh_subst_ident[of _ Z ys y] unfolding subst_def apply simp
  by(simp add: updEnv_commute)
qed

lemma substEnv_compose2:
assumes  "goodEnv rho" and "good Y" and "good Z"
and "ys \<noteq> zs \<or> y \<noteq> z" and fresh: "fresh ys y Z"
shows "((rho &[Y / y]_ys) &[Z / z]_zs) = ((rho &[Z / z]_zs) &[(Y #[Z / z]_zs) / y]_ys)"
proof-
  have "goodEnv (idEnv [y \<leftarrow> Y]_ys) \<and> goodEnv (idEnv [z \<leftarrow> Z]_zs)" using assms by simp
  thus ?thesis using assms unfolding subst_def substEnv_def
  apply(simp add: psubstEnv_compose psubstEnv_updEnv)
  using fresh_subst_ident[of _ Z ys y] unfolding subst_def apply simp
  by(simp add: updEnv_commute)
qed

lemma subst_vsubst_compose2:
assumes  "good X" and "good Z"
and "ys \<noteq> zs \<or> y \<noteq> z" and fresh: "fresh ys y Z"
shows "((X #[y1 // y]_ys) #[Z / z]_zs) = ((X #[Z / z]_zs) #[((Var ys y1) #[Z / z]_zs) / y]_ys)"
using assms unfolding vsubst_def by(simp add: subst_compose2)

lemma substEnv_vsubstEnv_compose2:
assumes  "goodEnv rho" and "good Z"
and "ys \<noteq> zs \<or> y \<noteq> z" and fresh: "fresh ys y Z"
shows "((rho &[y1 // y]_ys) &[Z / z]_zs) = ((rho &[Z / z]_zs) &[((Var ys y1) #[Z / z]_zs) / y]_ys)"
using assms unfolding vsubstEnv_def by(simp add: substEnv_compose2)

lemma vsubst_subst_compose2:
assumes  "good X" and "good Y"
and "ys \<noteq> zs \<or> y \<notin> {z,z1}"
shows "((X #[Y / y]_ys) #[z1 // z]_zs) = ((X #[z1 // z]_zs) #[(Y #[z1 // z]_zs) / y]_ys)"
using assms unfolding vsubst_def by(simp add: subst_compose2)

lemma vsubstEnv_substEnv_compose2:
assumes  "goodEnv rho" and "good Y"
and "ys \<noteq> zs \<or> y \<notin> {z,z1}"
shows "((rho &[Y / y]_ys) &[z1 // z]_zs) = ((rho &[z1 // z]_zs) &[(Y #[z1 // z]_zs) / y]_ys)"
using assms unfolding vsubst_def vsubstEnv_def by(simp add: substEnv_compose2)

lemma vsubst_compose2:
assumes  "good X"
and "ys \<noteq> zs \<or> y \<notin> {z,z1}"
shows "((X #[y1 // y]_ys) #[z1 // z]_zs) =
       ((X #[z1 // z]_zs) #[(y1 @ys[z1 / z]_zs) // y]_ys)"
unfolding vsubst_def
using assms apply(simp add: subst_compose2)
unfolding sb_def by auto

lemma vsubstEnv_compose2:
assumes "goodEnv rho"
and "ys \<noteq> zs \<or> y \<notin> {z,z1}"
shows "((rho &[y1 // y]_ys) &[z1 // z]_zs) =
       ((rho &[z1 // z]_zs) &[(y1 @ys[z1 / z]_zs) // y]_ys)"
unfolding vsubstEnv_def
using assms apply(simp add: substEnv_compose2)
unfolding sb_def by auto

subsection {* Properties specific to variable-for-variable substitution *}

(* Note: The results in this section cannot be lifted to environments, and therefore
we don't have ``environment versions" of these.  *)

lemma vsubstAll_ident:
fixes X::"('index,'bindex,'varSort,'var,'opSym)term" and
      A::"('index,'bindex,'varSort,'var,'opSym)abs" and
      P::"('index,'bindex,'varSort,'var,'opSym)param" and zs
assumes P: "goodPar P"
shows
"(good X \<longrightarrow>
  (\<forall> z. z \<in> varsOf P \<longrightarrow> (X #[z // z]_zs) = X))
\<and>
 (goodAbs A \<longrightarrow>
  (\<forall> z. z \<in> varsOf P \<longrightarrow> (A $[z // z]_zs) = A))"
apply(rule term_induct_fresh) using P apply simp_all
(*  *)
apply clarify
unfolding vsubstInp_def vsubst_def substInp_def2
          vsubstBinp_def vsubstAbs_def substBinp_def2 lift_def
apply(intro conjI)
apply(rule ext, case_tac "inp i", simp_all)
unfolding liftAll_def apply simp
apply(rule ext, case_tac "binp i", simp_all)
(*  *)
apply clarify by(subgoal_tac "x \<noteq> z", auto)

corollary vsubst_ident[simp]:
assumes "good X"
shows "(X #[z // z]_zs) = X"
using assms vsubstAll_ident[of "Par [z] [] [] []" X]
unfolding goodPar_def by simp

corollary subst_ident[simp]:
assumes "good X"
shows "(X #[(Var zs z) / z]_zs) = X"
using assms vsubst_ident unfolding vsubst_def by auto

lemma vsubstAll_swapAll:
fixes X::"('index,'bindex,'varSort,'var,'opSym)term" and
      A::"('index,'bindex,'varSort,'var,'opSym)abs" and
      P::"('index,'bindex,'varSort,'var,'opSym)param" and ys
assumes P: "goodPar P"
shows
"(good X \<longrightarrow>
  (\<forall> y1 y2. {y1,y2} \<subseteq> varsOf P \<and> fresh ys y1 X \<longrightarrow>
            (X #[y1 // y2]_ys) = (X #[y1 \<and> y2]_ys)))
\<and>
 (goodAbs A \<longrightarrow>
  (\<forall> y1 y2. {y1,y2} \<subseteq> varsOf P \<and> freshAbs ys y1 A  \<longrightarrow>
            (A $[y1 // y2]_ys) = (A $[y1 \<and> y2]_ys)))"
apply(rule term_induct_fresh[OF P])
apply (force simp add: sw_def)
  apply clarify
  apply simp apply(rule conjI)
  apply(force intro: ext
        simp add: vsubstInp_def substInp_def2 vsubst_def swapInp_def lift_def
                  freshInp_def liftAll_def
        split: option.splits)
  apply(force intro: ext
        simp add: vsubstBinp_def substBinp_def2 vsubstAbs_def swapBinp_def lift_def
                  freshBinp_def liftAll_def
        split: option.splits)
  apply clarsimp
  by (metis Var_preserves_good fresh_Var_simp substAbs_simp sw_def
            vsubstAbs_def vsubst_def)

corollary vsubst_eq_swap:
assumes "good X" and "y1 = y2 \<or> fresh ys y1 X"
shows "(X #[y1 // y2]_ys) = (X #[y1 \<and> y2]_ys)"
apply(cases "y1 = y2") using assms apply simp
using assms vsubstAll_swapAll[of "Par [y1, y2] [] [] []" X]
unfolding goodPar_def by simp

lemma skelAll_vsubstAll:
fixes X::"('index,'bindex,'varSort,'var,'opSym)term" and
      A::"('index,'bindex,'varSort,'var,'opSym)abs" and
      P::"('index,'bindex,'varSort,'var,'opSym)param" and ys
assumes P: "goodPar P"
shows
"(good X \<longrightarrow>
  (\<forall> y1 y2. {y1,y2} \<subseteq> varsOf P \<longrightarrow>
            skel (X #[y1 // y2]_ys) = skel X))
\<and>
 (goodAbs A \<longrightarrow>
  (\<forall> y1 y2. {y1,y2} \<subseteq> varsOf P \<longrightarrow>
            skelAbs (A $[y1 // y2]_ys) = skelAbs A))"
apply(rule term_induct_fresh) using P apply simp_all apply(tactic {* clarify_all_tac @{context} *})
proof-
  fix inp :: "('index,('index,'bindex,'varSort,'var,'opSym)term)input" and
  binp :: "('bindex,('index,'bindex,'varSort,'var,'opSym)abs)input" and P y1 y2
  assume inp: "goodInp inp"   "goodBinp binp"
  and IH:
  "liftAll (\<lambda>X. \<forall>y1 y2. y1 \<in> varsOf P \<and> y2 \<in> varsOf P
                        \<longrightarrow> skel (X #[y1 // y2]_ys) = skel X) inp"
  "liftAll (\<lambda>A. \<forall>y1 y2. y1 \<in> varsOf P \<and> y2 \<in> varsOf P
                        \<longrightarrow> skelAbs (A $[y1 // y2]_ys) = skelAbs A) binp"
  and y1y2: "y1 \<in> varsOf P" "y2 \<in> varsOf P"
  thus "skelInp (inp %[y1 // y2]_ys) = skelInp inp \<and>
        skelBinp (binp %%[y1 // y2]_ys) = skelBinp binp"
  apply(simp add: skelInp_def2 skelBinp_def2)
  unfolding vsubst_def vsubstInp_def substInp_def2
            vsubstAbs_def vsubstBinp_def substBinp_def2 unfolding lift_comp
  unfolding lift_def apply(intro conjI)
  apply(rule ext) apply(case_tac "inp i", simp_all)
  unfolding liftAll_def apply simp
  apply(rule ext) by(case_tac "binp i", simp_all)
next
  fix xs x X P y1 y2
  assume X: "good X" and "x \<notin> varsOf P" and IH:
  "\<forall>y1 y2. y1 \<in> varsOf P \<and> y2 \<in> varsOf P \<longrightarrow>
           skel (vsubst ys y1 y2 X) = skel X"
  and y1y2: "y1 \<in> varsOf P" "y2 \<in> varsOf P"
  hence "x \<notin> {y1,y2}" by auto
  thus "skelAbs (vsubstAbs ys y1 y2 (Abs xs x X)) =
        Branch (\<lambda>i. Some (skel X)) empty"
  using X y1y2 IH by simp
qed

corollary skel_vsubst:
assumes "good X"
shows "skel (X #[y1 // y2]_ys) = skel X"
using assms skelAll_vsubstAll[of "Par [y1, y2] [] [] []" X]
unfolding goodPar_def by simp

lemma subst_vsubst_trans:
assumes  "good X" and "good Y" and "fresh ys y1 X"
shows "((X #[y1 // y]_ys) #[Y / y1]_ys) = (X #[Y / y]_ys)"
using assms apply(cases "y1 = y") apply simp
unfolding subst_def vsubst_def apply(simp add: psubst_compose)
by(rule psubst_cong, simp_all)

lemma vsubst_trans:
assumes  "good X" and "fresh ys y1 X"
shows "((X #[y1 // y]_ys) #[y2 // y1]_ys) = (X #[y2 // y]_ys)"
unfolding vsubst_def[of _ y2 y1] vsubst_def[of _ y2 y]
using assms by(simp add: subst_vsubst_trans)

lemma vsubst_commute:
assumes X: "good X"
and "xs \<noteq> xs' \<or> {x,y} \<inter> {x',y'} = {}" and "fresh xs x X" and "fresh xs' x' X"
shows "((X #[x // y]_xs) #[x' // y']_xs') = ((X #[x' // y']_xs') #[x // y]_xs)"
proof-
  have "fresh xs' x' (X #[x // y]_xs)"
  apply(rule vsubst_preserves_fresh) using assms by auto
  moreover have "fresh xs x (X #[x' // y']_xs')"
  apply(rule vsubst_preserves_fresh) using assms by auto
  ultimately show ?thesis using assms apply(simp add: vsubst_eq_swap)
  apply(rule swap_commute) using assms by blast+
qed

subsection {* Abstraction versions of the properties *}

text{* Environment identity and update versus other operators: *}

lemma psubstAbs_idEnv[simp]:
"goodAbs A \<Longrightarrow> (A $[idEnv]) = A"
by(simp add: psubstAll_idEnv)

text{* Substitution versus other operators:  *}

corollary freshAbs_psubstAbs:
assumes "goodAbs A" and "goodEnv rho"
shows
"freshAbs zs z (A $[rho]) =
 (\<forall> ys y. freshAbs ys y A \<or> freshImEnvAt zs z rho ys y)"
using assms freshAll_psubstAll[of "Par [z] [] [] [rho]"]
unfolding goodPar_def by simp

corollary freshAbs_psubstAbs_E1:
assumes "goodAbs A" and "goodEnv rho"
and "rho ys y = None" and "freshAbs zs z (A $[rho])"
shows "freshAbs ys y A \<or> (ys \<noteq> zs \<or> y \<noteq> z)"
using assms freshAbs_psubstAbs unfolding freshImEnvAt_def by fastforce

corollary freshAbs_psubstAbs_E2:
assumes "goodAbs A" and "goodEnv rho"
and "rho ys y = Some Y" and "freshAbs zs z (A $[rho])"
shows "freshAbs ys y A \<or> fresh zs z Y"
using assms freshAbs_psubstAbs[of A rho] unfolding freshImEnvAt_def by fastforce

corollary freshAbs_psubstAbs_I1:
assumes "goodAbs A" and "goodEnv rho"
and "freshAbs zs z A" and "freshEnv zs z rho"
shows "freshAbs zs z (A $[rho])"
using assms apply(simp add: freshAbs_psubstAbs)
unfolding freshEnv_def liftAll_def freshImEnvAt_def by auto

corollary freshAbs_psubstAbs_I:
assumes "goodAbs A" and "goodEnv rho"
and "rho zs z = None \<Longrightarrow> freshAbs zs z A" and
    "\<And> ys y Y. rho ys y = Some Y \<Longrightarrow> freshAbs ys y A \<or> fresh zs z Y"
shows "freshAbs zs z (A $[rho])"
using assms apply(simp add: freshAbs_psubstAbs)
unfolding freshImEnvAt_def apply auto
proof-
  fix ys y
  assume *: "\<And>ys y Y. rho ys y = Some Y \<Longrightarrow> freshAbs ys y A \<or> fresh zs z Y"
  "\<not> freshAbs ys y A" "\<forall>Y. rho ys y = Some Y \<longrightarrow> \<not> fresh zs z Y"
  {fix Y assume "rho ys y = Some Y"
   hence False using * by auto
  }
  thus "rho ys y = None" by fastforce
qed

lemma freshAbs_substAbs:
assumes "goodAbs A" and "good Y"
shows "freshAbs zs z (A $[Y / y]_ys) =
       (((zs = ys \<and> z = y) \<or> freshAbs zs z A) \<and> (freshAbs ys y A \<or> fresh zs z Y))"
unfolding substAbs_def
using assms apply(simp add: freshAbs_psubstAbs)
unfolding freshImEnvAt_def by auto

lemma freshAbs_vsubstAbs:
assumes "goodAbs A"
shows "freshAbs zs z (A $[y1 // y]_ys) =
       (((zs = ys \<and> z = y) \<or> freshAbs zs z A) \<and>
        (freshAbs ys y A \<or> (zs \<noteq> ys \<or> z \<noteq> y1)))"
unfolding vsubstAbs_def using assms by(auto simp add: freshAbs_substAbs)

lemma substAbs_preserves_freshAbs:
assumes "goodAbs A" and "good Y"
and "freshAbs zs z A" and "fresh zs z Y"
shows "freshAbs zs z (A $[Y / y]_ys)"
using assms by(simp add: freshAbs_substAbs)

lemma vsubstAbs_preserves_freshAbs:
assumes "goodAbs A"
and "freshAbs zs z A" and "zs \<noteq> ys \<or> z \<noteq> y1"
shows "freshAbs zs z (A $[y1 // y]_ys)"
using assms by(simp add: freshAbs_vsubstAbs)

lemma fresh_freshAbs_substAbs[simp]:
assumes "good Y" and "goodAbs A"
and "fresh ys y Y"
shows "freshAbs ys y (A $[Y / y]_ys)"
using assms by(simp add: freshAbs_substAbs)

lemma diff_freshAbs_vsubstAbs[simp]:
assumes "goodAbs A"
and "y \<noteq> y1"
shows "freshAbs ys y (A $[y1 // y]_ys)"
using assms by(simp add: freshAbs_vsubstAbs)

lemma freshAbs_substAbs_E1:
assumes "goodAbs A" and "good Y"
and "freshAbs zs z (A $[Y / y]_ys)" and "zs \<noteq> ys \<or> z \<noteq> y"
shows "freshAbs zs z A"
using assms by(auto simp add: freshAbs_substAbs)

lemma freshAbs_vsubstAbs_E1:
assumes "goodAbs A"
and "freshAbs zs z (A $[y1 // y]_ys)" and "zs \<noteq> ys \<or> z \<noteq> y"
shows "freshAbs zs z A"
using assms by(auto simp add: freshAbs_vsubstAbs)

lemma freshAbs_substAbs_E2:
assumes "goodAbs A" and "good Y"
and "freshAbs zs z (A $[Y / y]_ys)"
shows "freshAbs ys y A \<or> fresh zs z Y"
using assms by(simp add: freshAbs_substAbs)

lemma freshAbs_vsubstAbs_E2:
assumes "goodAbs A"
and "freshAbs zs z (A $[y1 // y]_ys)"
shows "freshAbs ys y A \<or> zs \<noteq> ys \<or> z \<noteq> y1"
using assms by(simp add: freshAbs_vsubstAbs)

corollary psubstAbs_cong[fundef_cong]:
assumes "goodAbs A" and "goodEnv rho" and "goodEnv rho'"
and "\<And> ys y. freshAbs ys y A \<or> rho ys y = rho' ys y"
shows "(A $[rho]) = (A $[rho'])"
using assms psubstAll_cong[of "Par [] [] [] [rho,rho']"]
unfolding goodPar_def by simp

lemma freshAbs_psubstAbs_updEnv:
assumes "good X" and "goodAbs A" and "goodEnv rho"
and "freshAbs xs x A"
shows "(A $[rho [x \<leftarrow> X]_xs]) = (A $[rho])"
apply(rule psubstAbs_cong)
using assms by auto

corollary freshEnv_psubstAbs_ident[simp]:
fixes A :: "('index,'bindex,'varSort,'var,'opSym)abs"
assumes "goodAbs A" and "goodEnv rho"
and "\<And> zs z. freshEnv zs z rho \<or> freshAbs zs z A"
shows "(A $[rho]) = A"
using assms
psubstAll_ident[of "Par [] [] [] [rho]"]
unfolding goodPar_def by simp

lemma freshAbs_substAbs_ident[simp]:
assumes "good X" and "goodAbs A" and "freshAbs xs x A"
shows "(A $[X / x]_xs) = A"
proof-
  have "(A $[X / x]_xs) = (A $[idEnv])"
  unfolding substAbs_def apply(rule freshAbs_psubstAbs_updEnv)
  using assms by auto
  thus ?thesis using assms psubstAbs_idEnv by auto
qed

corollary substAbs_Abs[simp]:
assumes "good X" and "good Y"
shows "((Abs xs x X) $[Y / x]_xs) = Abs xs x X"
using assms by simp

lemma freshAbs_vsubstAbs_ident[simp]:
assumes "goodAbs A" and "freshAbs xs x A"
shows "(A $[x1 // x]_xs) = A"
using assms unfolding vsubstAbs_def by(auto simp add: freshAbs_substAbs_ident)

lemma swapAbs_psubstAbs:
assumes "goodAbs A" and "goodEnv rho"
shows "((A $[rho]) $[z1 \<and> z2]_zs) = ((A $[z1 \<and> z2]_zs) $[rho &[z1 \<and> z2]_zs])"
using assms swapAll_psubstAll[of "Par [z1,z2] [] [] [rho]"]
unfolding goodPar_def by auto

lemma swapAbs_substAbs:
assumes "goodAbs A" and "good Y"
shows "((A $[Y / y]_ys) $[z1 \<and> z2]_zs) =
       ((A $[z1 \<and> z2]_zs) $[(Y #[z1 \<and> z2]_zs) / (y @ys[z1 \<and> z2]_zs)]_ys)"
proof-
  have 1: "(idEnv [(y @ys[z1 \<and> z2]_zs) \<leftarrow> (Y #[z1 \<and> z2]_zs)]_ys) =
           ((idEnv [y \<leftarrow> Y]_ys) &[z1 \<and> z2]_zs)"
  by(simp add: swapEnv_updEnv)
  show ?thesis
  unfolding substAbs_def 1 apply (rule swapAbs_psubstAbs)
  using assms by auto
qed

lemma swapAbs_vsubstAbs:
assumes "goodAbs A"
shows "((A $[y1 // y]_ys) $[z1 \<and> z2]_zs) =
       ((A $[z1 \<and> z2]_zs) $[(y1 @ys[z1 \<and> z2]_zs) // (y @ys[z1 \<and> z2]_zs)]_ys)"
using assms unfolding vsubstAbs_def
by(simp add: swapAbs_substAbs)

lemma psubstAbs_compose:
assumes "goodAbs A" and "goodEnv rho" and "goodEnv rho'"
shows "((A $[rho]) $[rho']) = (A $[(rho &[rho'])])"
using assms psubstAll_compose[of "Par [] [] [] [rho, rho']"]
unfolding goodPar_def by auto

lemma psubstAbs_substAbs_compose:
assumes "goodAbs A" and "good Y" and "goodEnv rho"
shows "((A $[Y / y]_ys) $[rho]) = (A $[(rho [y \<leftarrow> (Y #[rho])]_ys)])"
proof-
  have "goodEnv (idEnv [y \<leftarrow> Y]_ys)" using assms by simp
  thus ?thesis using assms unfolding substAbs_def substEnv_def
  by(simp add: psubstAbs_compose psubstEnv_updEnv_idEnv)
qed

lemma psubstAbs_vsubstAbs_compose:
assumes "goodAbs A" and "goodEnv rho"
shows "((A $[y1 // y]_ys) $[rho]) = (A $[(rho [y \<leftarrow> ((Var ys y1) #[rho])]_ys)])"
using assms unfolding vsubstAbs_def by(simp add: psubstAbs_substAbs_compose)

lemma substAbs_psubstAbs_compose:
assumes "goodAbs A" and "good Y" and "goodEnv rho"
shows "((A $[rho]) $[Y / y]_ys) = (A $[(rho &[Y / y]_ys)])"
unfolding substAbs_def substEnv_def using assms by(simp add: psubstAbs_compose)

lemma psubstAbs_substAbs_compose_freshEnv:
assumes "goodAbs A" and "goodEnv rho" and "good Y"
assumes "freshEnv ys y rho"
shows "((A $[Y / y]_ys) $[rho]) = ((A $[rho]) $[(Y #[rho]) / y]_ys)"
using assms by (simp add: substAbs_psubstAbs_compose psubstAbs_substAbs_compose)

lemma vsubstAbs_psubstAbs_compose:
assumes "goodAbs A" and "goodEnv rho"
shows "((A $[rho]) $[y1 // y]_ys) = (A $[(rho &[y1 // y]_ys)])"
unfolding vsubstAbs_def vsubstEnv_def using assms
by(simp add: substAbs_psubstAbs_compose)

lemma substAbs_compose1:
assumes "goodAbs A" and "good Y1" and "good Y2"
shows "((A $[Y1 / y]_ys) $[Y2 / y]_ys) = (A $[(Y1 #[Y2 / y]_ys) / y]_ys)"
proof-
  have "goodEnv (idEnv [y \<leftarrow> Y1]_ys) \<and> goodEnv (idEnv [y \<leftarrow> Y2]_ys)" using assms by simp
  thus ?thesis using `goodAbs A` unfolding substAbs_def subst_def substEnv_def
  by(simp add: psubstAbs_compose psubstEnv_updEnv)
qed

lemma substAbs_vsubstAbs_compose1:
assumes "goodAbs A" and "good Y" and "y \<noteq> y1"
shows "((A $[y1 // y]_ys) $[Y / y]_ys) = (A $[y1 // y]_ys)"
using assms unfolding vsubstAbs_def by(simp add: substAbs_compose1)

lemma vsubstAbs_substAbs_compose1:
assumes "goodAbs A" and "good Y"
shows "((A $[Y / y]_ys) $[y1 // y]_ys) = (A $[(Y #[y1 // y]_ys) / y]_ys)"
using assms unfolding vsubstAbs_def vsubst_def by(simp add: substAbs_compose1)

lemma vsubstAbs_compose1:
assumes "goodAbs A"
shows "((A $[y1 // y]_ys) $[y2 // y]_ys) = (A $[(y1 @ys[y2 / y]_ys) // y]_ys)"
using assms unfolding vsubstAbs_def apply(simp add: substAbs_compose1)
by(cases "y = y1", auto)

lemma substAbs_compose2:
assumes  "goodAbs A" and "good Y" and "good Z"
and "ys \<noteq> zs \<or> y \<noteq> z" and fresh: "fresh ys y Z"
shows "((A $[Y / y]_ys) $[Z / z]_zs) = ((A $[Z / z]_zs) $[(Y #[Z / z]_zs) / y]_ys)"
proof-
  have "goodEnv (idEnv [y \<leftarrow> Y]_ys) \<and> goodEnv (idEnv [z \<leftarrow> Z]_zs)" using assms by simp
  thus ?thesis using assms unfolding substAbs_def subst_def substEnv_def
  apply(simp add: psubstAbs_compose psubstEnv_updEnv)
  using fresh_subst_ident[of _ Z ys y] unfolding subst_def apply simp
  by(simp add: updEnv_commute)
qed

lemma substAbs_vsubstAbs_compose2:
assumes  "goodAbs A" and "good Z"
and "ys \<noteq> zs \<or> y \<noteq> z" and fresh: "fresh ys y Z"
shows "((A $[y1 // y]_ys) $[Z / z]_zs) = ((A $[Z / z]_zs) $[((Var ys y1) #[Z / z]_zs) / y]_ys)"
using assms unfolding vsubstAbs_def by(simp add: substAbs_compose2)

lemma vsubstAbs_substAbs_compose2:
assumes  "goodAbs A" and "good Y"
and "ys \<noteq> zs \<or> y \<notin> {z,z1}"
shows "((A $[Y / y]_ys) $[z1 // z]_zs) = ((A $[z1 // z]_zs) $[(Y #[z1 // z]_zs) / y]_ys)"
using assms unfolding vsubstAbs_def vsubst_def by(simp add: substAbs_compose2)

lemma vsubstAbs_compose2:
assumes  "goodAbs A"
and "ys \<noteq> zs \<or> y \<notin> {z,z1}"
shows "((A $[y1 // y]_ys) $[z1 // z]_zs) =
       ((A $[z1 // z]_zs) $[(y1 @ys[z1 / z]_zs) // y]_ys)"
unfolding vsubstAbs_def
using assms apply(simp add: substAbs_compose2)
unfolding sb_def by auto

text{* Properties specific to variable-for-variable substitution: *}

corollary vsubstAbs_ident[simp]:
assumes "goodAbs A"
shows "(A $[z // z]_zs) = A"
using assms vsubstAll_ident[of "Par [z] [] [] []" _ _ A]
unfolding goodPar_def by simp

corollary substAbs_ident[simp]:
assumes "goodAbs A"
shows "(A $[(Var zs z) / z]_zs) = A"
using assms vsubstAbs_ident unfolding vsubstAbs_def by auto

corollary vsubstAbs_eq_swapAbs:
assumes "goodAbs A" and "freshAbs ys y1 A"
shows "(A $[y1 // y2]_ys) = (A $[y1 \<and> y2]_ys)"
using assms vsubstAll_swapAll[of "Par [y1, y2] [] [] []" _ _ A]
unfolding goodPar_def by simp

corollary skelAbs_vsubstAbs:
assumes "goodAbs A"
shows "skelAbs (A $[y1 // y2]_ys) = skelAbs A"
using assms skelAll_vsubstAll[of "Par [y1, y2] [] [] []" _ _ A]
unfolding goodPar_def by simp

lemma substAbs_vsubstAbs_trans:
assumes  "goodAbs A" and "good Y" and "freshAbs ys y1 A"
shows "((A $[y1 // y]_ys) $[Y / y1]_ys) = (A $[Y / y]_ys)"
using assms apply(cases "y1 = y", simp_all)
unfolding substAbs_def vsubstAbs_def apply(simp add: psubstAbs_compose)
by(rule psubstAbs_cong, simp_all)

lemma vsubstAbs_trans:
assumes  "goodAbs A" and "freshAbs ys y1 A"
shows "((A $[y1 // y]_ys) $[y2 // y1]_ys) = (A $[y2 // y]_ys)"
unfolding vsubstAbs_def[of _ y2 y1] vsubstAbs_def[of _ y2 y]
using assms by(simp add: substAbs_vsubstAbs_trans)

lemmas good_psubstAll_freshAll_otherSimps =
psubst_idEnv psubstEnv_idEnv_id psubstAbs_idEnv
freshEnv_psubst_ident freshEnv_psubstAbs_ident

lemmas good_substAll_freshAll_otherSimps =
fresh_fresh_subst fresh_subst_ident fresh_substEnv_updEnv subst_ident
fresh_freshAbs_substAbs freshAbs_substAbs_ident substAbs_ident

lemmas good_vsubstAll_freshAll_otherSimps =
diff_fresh_vsubst fresh_vsubst_ident fresh_vsubstEnv_updEnv vsubst_ident
diff_freshAbs_vsubstAbs freshAbs_vsubstAbs_ident vsubstAbs_ident

lemmas good_allOpers_otherSimps =
good_swapAll_freshAll_otherSimps
good_psubstAll_freshAll_otherSimps
good_substAll_freshAll_otherSimps
good_vsubstAll_freshAll_otherSimps

lemmas good_item_simps =
param_simps
all_preserve_good
good_freeCons
good_allOpers_simps
good_allOpers_otherSimps

end  (* context FixVars *)

end
